/* $Id: hisuberr.h,v 1.3 2002/02/08 16:27:19 chris Exp $ */

#ifndef __HISUBERR_H__
#define __HISUBERR_H__

#define NO_SUB_ERROR 0

/*
 * Library errors.
 */
#define ERROR_LOAD_LIB                      0x00000001
#define ERROR_GET_PROC_ADDR                 0x00000002
#define ERROR_FREE_LIB                      0x00000003
#define ERROR_GET_VER_EX                    0x00000004
#define CANNOT_ALLOC_MEM                    0x00000005
#define ERROR_GET_DATE_FORMAT               0x00000006

/*
 * Database registry errors.
 */
#define ERROR_OPENING_REGISTRY              0x00010001
#define ERROR_CLOSING_REGISTRY              0x00010002
#define ERROR_SETTING_VALUE_REGISTRY        0x00010003
#define ERROR_DELETING_VALUE_REGISTRY       0x00010004
#define ERROR_DELETING_REGISTRY             0x00010005
#define ERROR_QUERY_REGISTRY                0x00010006
#define ERROR_CREATING_REGISTRY             0x00010007
#define ERROR_CANNOT_ADD_PCMCIA_ENTRIES     0x00010008
#define ERROR_MISSING_REG_DATA              0x00010009
#define ERROR_INVALID_REG_DATA              0x0001000a

/*
 * Services database errors.
 */
#define OPEN_SERVICE_MANAGER_ERROR          0x00020001
#define CLOSE_SERVICE_REGISTRY_ERROR        0x00020002
#define CREATE_SERVICE_ERROR                0x00020003
#define CLOSING_SERVICE_ERROR               0x00020004
#define OPEN_SERVICE_ERROR                  0x00020005
#define STOP_SERVICE_ERROR                  0x00020006
#define START_SERVICE_ERROR                 0x00020007
#define DELETING_SERVICE_ERROR              0x00020008
#define CLOSING_SERVICE_MANAGER_ERROR       0x00020009
#define LM_NOT_EXISTS                       0x00020010

/*
 * File errors.
 */
#define CANNOT_DELETE_FILE                  0x00040001
#define CANNOT_MOVE_FILE                    0x00040002
#define ERROR_CREATE_FILE                   0x00040003
#define ERROR_WRITE_FILE                    0x00040004
#define ERROR_CLOSE_FILE                    0x00040005
#define ERROR_OPEN_FILE                     0x00040006
#define COPY_FILE_ERROR                     0x00040007
#define ERROR_GET_FILE_SIZE                 0x00040008
#define CANNOT_SET_FILE_POINTER             0x00040009
#define ERROR_READ_FILE                     0x0004000a
#define ERROR_ACCESS_FILE                   0x0004000b
#define ERROR_COPY_FILE                     0x0004000c
#define ERROR_CREATE_DIRECTORY				0x0004000d

/*
 * Miscellaneous errors.
 */
#define FATAL_ERROR                         0x00080001
#define CANNOT_FIND_SECTION                 0x00080002
#define CANNOT_FIND_HASP36_SIG              0x00080003
#define ERROR_EXECUTE_GETFILEATTRIBUTE      0x00080004
#define HI_FILE_ATTRIBUTE_READONLY          0x00080005
#define SYSTEM_INI_NOT_FOUND                0x00080006

/*
 * Hardlock installation errors.
 */
#define ERROR_NOT_RUNNING_UNDER_NT          0x00090001
#define ERROR_NOTENOUGH_MEMORY              0x00090003
#define ERROR_INTERNAL_PROCESS_OVERFLOW     0x00090004
#define ERROR_CANNOT_OPEN_HARDLOCKSYS       0x00090005
#define ERROR_HARDLOCKSYS_TOO_OLD           0x00090006
#define ERROR_BUFFER_TOO_SMALL              0x00090007

/*
 * SetupApi errors.
 */
#define GET_CLASS_DEVS_ERROR				0x00000008
#define GET_DEVICE_PROPERTY_ERROR			0x00000009
#define CALL_CLASS_INSTALLER_ERROR			0x00000009
#define INSTALL_ALREADY_IN_PROGRESS			0x0000000a
#define UPDATE_DRV_FOR_PNP_ERROR			0x0000000b
#define NO_MORE_ITEMS						0x0000000c
#define INSTALL_ROOT_ERROR		 			0x0000000d

#endif /* #ifndef __HISUBERR_H__ */
